function varargout = radar(varargin)
% RADAR M-file for radar.fig
%      RADAR, by itself, creates a new RADAR or raises the existing
%      singleton*.
%
%      H = RADAR returns the handle to a new RADAR or the handle to
%      the existing singleton*.
%
%      RADAR('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in RADAR.M with the given input arguments.
%
%      RADAR('Property','Value',...) creates a new RADAR or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before radar_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to radar_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help radar

% Last Modified by GUIDE v2.5 25-Jan-2006 10:59:31

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @radar_OpeningFcn, ...
                   'gui_OutputFcn',  @radar_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin & isstr(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before radar is made visible.
function radar_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to radar (see VARARGIN)

% Choose default command line output for radar
handles.output = hObject;

fig = gcf;
set(fig,'Name','Radar Example');

% **************** Add Table1 *************************

tbl = axes('units', 'pixels','position', [50 70 260 100]);
cell_data = {... 
'Absent', 0.45, 0.2, 0.05;...
'Present', 0.02, 0.08, 0.20};

columninfo.titles={'','Low (0)','Medium (?)',...
'High (1)'};
columninfo.formats = {'%4.6g','%4.6g','%4.6g','%4.6g'};
columninfo.weight = [ 1, 1, 1, 1];
columninfo.multipliers = [ 1, 1, 1, 1];
columninfo.isEditable = [ 0, 1, 1, 1];
columninfo.isNumeric = [ 0, 1, 1, 1];
columninfo.withCheck = false;
% columninfo.chkLabel = 'Use';
columninfo.rowsFixed = true;
rowHeight = 16;
gFont.size=9;
gFont.name='Helvetica';

mltable(fig, tbl, 'CreateTable', columninfo, rowHeight, cell_data,... 
gFont);

handles.tblParams1  = tbl;

endfcn = sprintf('mltable(%14.13f, %14.13f, ''SetCellValue'');',...
hObject,handles.tblParams1);
set(hObject,'buttondownfcn',endfcn);

% **************** Add Table2 *************************

tbl = axes('units', 'pixels','position', [320 70 260 100]);
cell_data = {... 
'Absent', 0.1125, 0.05, 0.0125;...
'Present', 0.055, 0.22, 0.55};

columninfo.titles={'','Low (0)','Medium (?)',...
'High (1)'};
columninfo.formats = {'%4.6g','%4.6g','%4.6g','%4.6g'};
columninfo.weight = [ 1, 1, 1, 1];
columninfo.multipliers = [ 1, 1, 1, 1];
columninfo.isEditable = [ 0, 1, 1, 1];
columninfo.isNumeric = [ 0, 1, 1, 1];
columninfo.withCheck = false;
% columninfo.chkLabel = 'Use';
columninfo.rowsFixed = true;
rowHeight = 16;
gFont.size=9;
gFont.name='Helvetica';

mltable(fig, tbl, 'CreateTable', columninfo, rowHeight, cell_data,... 
gFont);

handles.tblParams2  = tbl;

endfcn = sprintf('mltable(%14.13f, %14.13f, ''SetCellValue'');',...
hObject,handles.tblParams2);
set(hObject,'buttondownfcn',endfcn);

% **************** Show plot area *************************

axes(handles.axes1);
plot([0 0.001 1],[1 4 4],'k');
set(handles.axes1,'YTickLabelMode','manual');
set(handles.axes1,'YTick',[1 1.5 2 2.5 3 3.5 4]);

set(handles.axes1,'YTickLabel',['   '; '(0)'; '   '; '(?)'; '   '; '(1)'; '   ']);
set(get(handles.axes1,'XLabel'),'String','Threat Prior, p');
set(get(handles.axes1,'YLabel'),'String','Decision Region');

% Update handles structure
guidata(hObject, handles);


% UIWAIT makes radar wait for user response (see UIRESUME)
% uiwait(handles.figure1);



% --- Outputs from this function are returned to the command line.
function varargout = radar_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes during object creation, after setting all properties.
function listbox1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to listbox1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end






% --- Executes on button press in pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

tbl1 = handles.tblParams1;
tbl2 = handles.tblParams2;
info1 = get(tbl1,'UserData');
info2 = get(tbl2,'UserData');
data1 = info1.data;
data2 = info2.data;
[n m] = size(data1);
P1=zeros(n,m-1);
P2=zeros(n,m-1);
for i=1:n
    for j=2:m
        P1(i,j-1)=data1{i,j};
        P2(i,j-1)=data2{i,j};
    end;
end;
P1=P1/sum(P1(:));
P2=P2/sum(P2(:));

ruleset = [];
for p=linspace(0,1,100)
    r = rule(P1, P2, p);
    ruleset = [ruleset r];
end;

axes(handles.axes1);
plotrules(ruleset,handles);


function r = rule(P1, P2, p)
P=(1-p)*P1+p*P2;
L=0; M=0; H=0;
min = 1;
for l=1:2
    for m=1:2
        for h=1:2
            Pe = P(l,1)+P(m,2)+P(h,3);
            if(Pe<=min)
                min=Pe;
                r=[2-h;2-m;2-l];
            end;
        end;
    end;
end;
                
            
            
    



function plotrules(ruleset, handles)

ruleset=flipud(ruleset);
ruleset=[ruleset; zeros(size(ruleset(1,:)))];
ruleset=[ruleset zeros(size(ruleset(:,1)))];

[m,n]=size(ruleset);
map=[0.85 0.3 0.3; 0.2 0.7 0.4];
colormap(map);
for i=1:n-1
    r=ruleset;
	pcolor([i-1 i; i-1 i; i-1 i; i-1 i]/(n-1),[1 1; 2  2; 3 3; 4 4],[r(:,i) r(:,i+1)]);
    axis([0 1 1 4]);
	set(handles.axes1,'YTickLabelMode','manual');
	set(handles.axes1,'YTick',[1 1.5 2 2.5 3 3.5 4]);
	set(handles.axes1,'YTickLabel',['   '; '(0)'; '   '; '(?)'; '   '; '(1)'; '   ']);
	set(get(handles.axes1,'XLabel'),'String','Threat Prior, p');
	set(get(handles.axes1,'YLabel'),'String','Decision Region');
	pause(0.04);
end;
pcolor(ruleset);
set(handles.axes1,'YTickLabelMode','manual');
set(handles.axes1,'YTick',[1 1.5 2 2.5 3 3.5 4]);
set(handles.axes1,'YTickLabel',['   '; '(0)'; '   '; '(?)'; '   '; '(1)'; '   ']);
set(get(handles.axes1,'XLabel'),'String','Threat Prior, p');
set(get(handles.axes1,'YLabel'),'String','Decision Region');

x=get(gca,'XTick');
n=3;
x=floor(10^n*x/max(x(:)))/10^n;
set(gca,'XTickLabel',x); 
refresh(gcf);




